CREATE TYPE tsystem.dblink__connection
  AS ENUM (
    'default',
    'syncro'
  );

CREATE OR REPLACE FUNCTION tsystem.dblink__connectionstring__get(_t tsystem.dblink__connection DEFAULT 'default')
  RETURNS varchar AS $$
  DECLARE result varchar;
  BEGIN
    CASE _t
        WHEN 'default' THEN
            result := 'host=localhost port=' || inet_server_port()::integer || ' dbname=' || current_database() || ' user=SYS.dblink password=SYS.dblink';
        WHEN 'syncro' THEN
            result := 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro';
        ELSE
            RAISE EXCEPTION 'Unknown connection type: %', _t;
    END CASE;
    RETURN result;
  END $$ LANGUAGE plpgsql IMMUTABLE;